// -----------
// TRIGGERS EXAMPLE

// Rink size globals
float rink_width=1150;
float rink_length= 2100;

float arena_width=2200;
float arena_length= 2200;

float arena_height= 500;

team @team_1= _engine.create_team();  

position @position_c = _engine.create_position();


// Player Trigger Callback Function
void test_player_trigger_callback(player &this_player)
{
  client @this_client = this_player.get_client();
	_engine.server_send_notice("----------------------------------------\n" );
	_engine.server_send_notice(this_client.name + " is touching the player trigger\n");
}

// Player Elimination Trigger Callback Function
void test_player_elimination_trigger_callback(player &this_player)
{
  client @this_client = this_player.get_client();
  _engine.server_send_notice(this_client.name + "has touched the elimination trigger\n");
	_engine.server_send_notice("And has to wait until faceoff or new game to rejoin\n");
	this_player.eliminate();
}

// Player Tool Callback Function
void test_tool_trigger_callback(player &this_player)
{
  client @this_client = this_player.get_client();
  _engine.server_send_notice("---------------------------------------------\n" );
	_engine.server_send_notice(this_client.name + "'s stick is touching the tool trigger\n");
}

// Active Object Trigger Callback Function
void test_active_object_trigger_callback(active_object &this_active_object)
{
	_engine.server_send_notice("Active Object (ID: " + this_active_object.id + ") is touching the active object trigger\n");
}

 // Initialize is called when the engine is ready
void _initialize()
{
  
	print("[SCRIPT STARTED]\n");
	
	// -------------------------------
	
	
	// Create Player Trigger (RED)
	game_object @this_player_trigger = _engine.create_game_cube_trigger( 500,50,0,100,100,100);
	this_player_trigger.set_player_trigger_callback('test_player_trigger_callback');
	this_player_trigger.set_color(255,0,0,30);
	
	
	// Create Tool (stick) Trigger (BLUE)
	game_object @this_tool_trigger = _engine.create_game_cube_trigger( 500,50,400,100,100,100);
	this_tool_trigger.set_tool_trigger_callback('test_tool_trigger_callback');
	this_tool_trigger.set_color(0,0,255,30);
	
	
	// Create Active Object Trigger (GREEN)
	game_object @this_active_object_trigger = _engine.create_game_cube_trigger( 500,50,-400,100,100,100);
	this_active_object_trigger.set_active_object_trigger_callback('test_active_object_trigger_callback');
	this_active_object_trigger.set_color(0,255,0,30);
	
	// Elimination Trigger (BLACK)
	// Shows how to eliminate a player
	// Eliminations are always reset on new games
	// See start_play() below for how to reset eliminations every faceoff
	// See end_rount() below for how to reset eliminations every round (aka period)
	game_object @this_player_elimination_trigger = _engine.create_game_cube_trigger( -500,50,0,100,100,100);
	this_player_elimination_trigger.set_player_trigger_callback('test_player_elimination_trigger_callback');
	this_player_elimination_trigger.set_color(0,0,0,30);
	
	
	// --------------------------------
	
	
	
	_physics.set_gravity(0,-61,0);
	
	_engine.fullbright_nets=true;
	_engine.fullbright_players=false;
	_engine.shadows_tool=true;
	_engine.textured_active_object_shadows=false;
	
	// MAP
	_engine.set_map_size(1150,2100);

	// STATISTICS

	// POSITIONS
	
    // Center
    //position @position_c = _engine.create_position();
    position_c.set_name("Center");
    position_c.set_abbreviation("C");
    position_c.set_spawn(0,0);
	
 
	  
	
  // TEAM 1
  //team @team_1 = _engine.create_team();
  team_1.set_name("Example Team 1");
  team_1.set_abbreviation("EX1");
  team_1.set_color_stick (_engine.create_color(94,40,153,255));
  team_1.set_color_shirt (_engine.create_color(242,215,71,255));
  team_1.set_color_pants (_engine.create_color(94,40,153,255));
  team_1.set_color_gloves (_engine.create_color(94,40,153,255));
  team_1.set_color_hat (_engine.create_color(94,40,153,255));
  team_1.set_color_net (_engine.create_color(94,40,153,255));
  team_1.set_spawn (0,10,95,3.14159);
  
 
  create_play_area();


  // TEAM 2
  net @net_1 = _engine.create_net_square(0,0,(rink_length/2)*.8668,88,38,25,3,3.14159);
	net_1.set_team(team_1);

  net @net_2 = _engine.create_net_square(0,0,-(rink_length/2)*.8668,88,38,25,3,0);
  net_2.set_team(team_1);

	

	
	
	
	
	
	
	

  
  

	// PUCK MATERIAL
	physics_material @puck_material = _physics.create_material();
	puck_material.mode = dContactBounce | dContactSoftCFM | dContactSoftERP  ;
  puck_material.mu = 10.99;
  puck_material.bounce = .90;
  puck_material.bounce_vel = .90;
  puck_material.soft_cfm = .8003;
  puck_material.soft_erp = .39;
	
	

  

	
	
	// Example Net

	return;
}

// Deinitialize is called just prior to deinitializing the game engine or before switching mods
void _deinitialize()
{
	print("[SCRIPT ENDED]\n");
}

void create_play_area(){

  // LIGHTS
  game_object @shadow_light = _engine.create_game_light(0,50000);
  shadow_light.set_position(0,10000,0);
  shadow_light.set_rotation(90,0,0);
  shadow_light.set_color(1,1,1,1);
  shadow_light.light_cast_shadows(true);

    game_object @arena_light_1 = _engine.create_game_light(0,rink_length*1.75);
    arena_light_1.light_set_type(0);
    arena_light_1.light_cast_shadows(false);
    arena_light_1.set_position((rink_width)*-2.55,600,(rink_length)*-1.25);
    arena_light_1.set_color(1,1,1,0);
    
    game_object @arena_light_2 = _engine.create_game_light(0,rink_length*1.75);
    arena_light_2.light_set_type(0);
    arena_light_2.light_cast_shadows(false);
    arena_light_2.set_position((rink_width)*-2.55,600,(rink_length)*1.25);
    arena_light_2.set_color(1,1,1,0);
    
    game_object @arena_light_3 = _engine.create_game_light(0,rink_length*1.75);
    arena_light_3.light_set_type(0);
    arena_light_3.light_cast_shadows(false);
    arena_light_3.set_position((rink_width)*2.55,600,(rink_length)*-1.25);
    arena_light_3.set_color(1,1,1,0);
    
    game_object @arena_light_4 = _engine.create_game_light(0,rink_length*1.75);
    arena_light_4.light_set_type(0);
    arena_light_4.light_cast_shadows(false);
    arena_light_4.set_position((rink_width)*2.55,600,(rink_length)*1.25);
    arena_light_4.set_color(1,1,1,0);
    


 
  
  // ICE MATERIAL
	physics_material @ice_material = _physics.create_material();
	ice_material.mode =  dContactSoftCFM | dContactApprox0;
  ice_material.mu = .4;
  ice_material.bounce = .0;
  ice_material.soft_cfm = .0001;
  ice_material.soft_erp = .89;
  
  // TOOL ICE MATERIAL
	physics_material @tool_ice_material = _physics.create_material();
	tool_ice_material.mode =  dContactSoftCFM | dContactApprox0;
  tool_ice_material.mu = .4;
  tool_ice_material.bounce = .0;
  tool_ice_material.soft_cfm = .3;
  tool_ice_material.soft_erp = .49;
  
  // ENVIRONMENT MATERIAL
	physics_material @environment_material = _physics.create_material();
	environment_material.mode = dContactBounce | dContactSoftCFM ;
  environment_material.mu = .99;
  environment_material.bounce = .74;
  environment_material.soft_cfm = .01;
  environment_material.soft_erp = .85;

  // GROUND
	physics_object @ground = _physics.create_plane(0,1,0,0);
  ground.set_material(ice_material);
  ground.collision_group = COLLISION_GROUP_GROUND;
  ground.set_space(_physics.space_ground);

  // GROUND STICK COLLIDER
  physics_object @ground_stick = _physics.create_plane(0,1,0,-2.75);
  ground_stick.set_material(tool_ice_material);
  ground_stick.set_space(_physics.space_ground_stick);

  // ICE GRAPHIC
  game_object @ice_object = _engine.create_game_plane(rink_length,rink_width,-1);
  ice_object.load_texture("ice.png");
  ice_object.set_fullbright();
  ice_object.set_rotation(0,90,0);
	
	// CEILING
	game_object @ceiling=_engine.create_game_cube((arena_width), 1 ,(arena_length), 0);
	ceiling.set_position(0,arena_height, 0);
	ceiling.set_color(10,10,10,255);
  ceiling._physics_object.set_material(environment_material);
  ceiling._physics_object.set_space(_physics.space_environment);
  ceiling._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
  
	// WALLS
	game_object @side1=_engine.create_game_cube( (arena_width), arena_height,15., 0);
	side1.set_position(0., arena_height/2, -(arena_length/2));
	side1.set_color(125,125,125,255);
  side1._physics_object.set_material(environment_material);
  side1._physics_object.set_space(_physics.space_environment);
  side1._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;

  game_object @side2=_engine.create_game_cube( (arena_width), arena_height,15., 0);
  side2.set_position(0., arena_height/2, (arena_length/2));
  side2.set_color(125,125,125,255);
  side2._physics_object.set_material(environment_material);
  side2._physics_object.set_space(_physics.space_environment);
  side2._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;

  game_object @side3=_engine.create_game_cube( 15., arena_height,arena_length, 0);
  side3.set_position(-(arena_width/2), arena_height/2, 0.);
  side3.set_color(125,125,125,255);
  side3._physics_object.set_material(environment_material);
  side3._physics_object.set_space(_physics.space_environment);
  side3._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;

  game_object @side4=_engine.create_game_cube( 15., arena_height,arena_length, 0);
  side4.set_position((arena_width/2), arena_height/2, 0.);
  side4.set_color(125,125,125,255);
  side4._physics_object.set_material(environment_material);
  side4._physics_object.set_space(_physics.space_environment);
  side4._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
  
  
  
  
  
  //game_object @ramp=_engine.create_game_cube( 120, 12,270, 0);
	//ramp.set_position(-320., 20, 0);
	//ramp.set_rotation(.2,0,0);
  //ramp._physics_object.set_material(environment_material);
  //ramp._physics_object.set_space(_physics.space_environment);
  //ramp._physics_object.collision_group = COLLISION_GROUP_CUSTOM_GROUND;
  
  
	
	// Score Clock
	game_object @clock=_engine.create_game_cube( 115,80,115, 0);
  clock.set_position(0,255,0);
  clock.set_color(8,8,8,255);
  clock._physics_object.set_material(environment_material);
  clock._physics_object.set_space(_physics.space_environment);
  clock._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	
	// Stands
	float stand_seat_size = 20;
	
	for(int i = 0; i< 14; i++){
    game_object @stands_1 = _engine.create_game_cube(stand_seat_size,stand_seat_size,rink_length,-1);
    stands_1.set_position((rink_width/2)+stand_seat_size+(i * stand_seat_size),(i*stand_seat_size),0);
    stands_1.set_color(93-(i*3),62-(i*3),51-(i*3),255);
    
    game_object @stands_2 = _engine.create_game_cube(stand_seat_size,stand_seat_size,rink_length,-1);
    stands_2.set_position((-rink_width/2)-stand_seat_size-(i * stand_seat_size),(i*stand_seat_size),0);
    stands_2.set_color(93-(i*3),62-(i*3),51-(i*3),255);
  }
	
	
	
	//game_object @boards_mesh=_engine.create_game_mesh("facer2d.bsp", 220.36,220.35,220.345, -1);
	//boards_mesh.set_position(-24.5,-2,0);


	environment_object @boards_invisible = _engine.create_rounded_container(0,0 ,0,rink_width*.99,956,rink_length*.99,22,rink_width/3,25,1,false,true);

	//boards_invisible.set_color(250,250,250,10);
	
	environment_object @boards = _engine.create_rounded_container(0,0 ,0,rink_width*.99,56,rink_length*.99,22,rink_width/3,25,1,true,false);
	environment_object @glass =  _engine.create_rounded_container(0,29+500,0,rink_width*.99,1000,rink_length*.99,22,rink_width/3,25,2,true,false);
	 
	boards.set_color(250,250,250,255);
	glass.set_color(220,220,240,20);
  glass.set_material_flag(EMF_LIGHTING, false);
  
  
  
  


}

void _start_game(){
  print("[_start_game]\n");
  
  _engine.game_round_time = 5 * 60;
  

  
}

void _end_game(){
  print("[_end_game]\n");
}

void _start_round(){
  print("[_start_period]\n");
  
  

}

void _end_round(){  
  print("[_end_round]\n");
  
  
  _engine.clear_eliminations();
}

void _start_play(){
  print("[_start_play]\n");
  
  _engine.clear_eliminations();
  
  if(_engine.game_round > 0){
    active_object @new_puck = _engine.create_active_puck(0,30,0,3.2,2.55,0.02);
  }else{
 
      for(int z = 0; z < 8; z++){
        //print("Adding Puck\n");
        //active_object @new_puck = _engine.create_active_puck(sin(i*5),35+(i*5),cos(i*5),3.2,2.35,0.02);
        active_object @new_puck2 = _engine.create_active_puck(100*sin(z*45),35,100*cos(z*45),3.2,2.55,0.03);
        //active_object @new_puck = _engine.create_active_puck(0 * sin(i*2),90 + (i*3),0 * cos(i*5),3.2,2.35,0.02);
        //active_object @new_puck = _engine.create_active_puck(100 * sin(i*.15),90 + (i*3),100 * cos(i*.15),3.2,2.35,0.02);
      }
  }
      
}